/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.wizard;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.ui.preferences.PHPVersionConfigurationBlock;
import com.aptana.editor.php.internal.ui.wizard.Messages;
import com.aptana.projects.wizards.CommonWizardNewProjectCreationPage;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org2.eclipse.php.internal.core.PHPVersion;

public class PHPWizardNewProjectCreationPage
extends CommonWizardNewProjectCreationPage {
    private Combo fPHPVersions;
    private String selectedAlias;

    public PHPWizardNewProjectCreationPage(String pageName, IProjectTemplate projectTemplate) {
        super(pageName, projectTemplate);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite control = (Composite)this.getControl();
        Group group = new Group(control, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText(com.aptana.editor.php.internal.ui.preferences.Messages.PHPDevelopmentPage_compatibility);
        Label label = new Label((Composite)group, 0);
        label.setText(com.aptana.editor.php.internal.ui.preferences.Messages.PHPDevelopmentPage_phpVersion);
        this.fPHPVersions = new Combo((Composite)group, 2060);
        this.fPHPVersions.setItems(PHPVersionConfigurationBlock.PHP_VERSION_NAMES.toArray(new String[PHPVersionConfigurationBlock.PHP_VERSION_NAMES.size()]));
        this.selectedAlias = PHPVersion.getLatest().getAlias();
        this.setSelectedVersion(this.selectedAlias);
        this.fPHPVersions.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PHPWizardNewProjectCreationPage.this.selectedAlias = PHPVersionConfigurationBlock.PHP_ALIASES.get(PHPWizardNewProjectCreationPage.this.fPHPVersions.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Dialog.applyDialogFont((Control)control);
        this.setControl((Control)control);
    }

    public boolean isCloneFromGit() {
        return false;
    }

    public String getCloneURI() {
        return null;
    }

    public String getSelectedVersion() {
        return this.selectedAlias;
    }

    private void setSelectedVersion(String phpAlias) {
        int index = PHPVersionConfigurationBlock.PHP_ALIASES.indexOf(phpAlias);
        if (index < 0) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)("Unresolved PHP version: " + phpAlias), (Throwable)new Exception("Unresolved PHP version"), (String)"com.aptana.editor.php/debug");
            index = 0;
        }
        this.fPHPVersions.select(index);
    }

    public String getStepName() {
        return Messages.NewPHPProjectWizard_projectWizardStepLbl;
    }
}

